package gov.va.med.mhv.sso;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;


public class DsLogonAction extends Action {
	private static final Log logger = LogFactoryUtil.getLog(EAuthGateway.class);
	private FedCredSsoUtil fedCredSsoUtil = new FedCredSsoUtil();

	private boolean processDsLogonSSoForExistingUser(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		fedCredSsoUtil.logInfo(logger, "processDsLogonSSoForExistingUser for icn:" + 
			fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
		
		if(!fedCredSsoUtil.isMinimumAssuranceLevelMet(request)) {
			fedCredSsoUtil.logInfo(logger, "VA Assurance Level is < 2. Going to Anonymous page for icn:" + 
				fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
			fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_ASSURANCE_LEVEL_MSG);
			response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			return false;
		}
		
		String hash = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.HASH_PARAM);
		
		//JAZZ Story#39187 US REQ#1	Check if va_eauth_hash has NOT_FOUND OR is Null ; then show error msg
		//NOTE:After discussion with IAM team, The following is not checked because hash can be more than 28 characters
		//Check if va_eauth_hash is 28 chracters and ends with a = character:
		//27 character that are in the ranges a-z, A-Z, 0-9 and the special characters + and /.
		//These are followed by an = character for a total of 28 characters. Example: CpjrdSXMPb2P+YK2VOCV81I/iW0=
		//If above check (va_eauth_hash is 28 characters) fails then show error message
		if(hash != null && fedCredSsoUtil.isNotFound(hash)) {
			fedCredSsoUtil.logInfo(logger, "hash value is NOT_FOUND, going to error page icn:" + 
				fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
			
			fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_HASH_MSG);
			response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			return false;
		}
		
		String username = findUserNameByHash(hash);
		if(username == null) {
			fedCredSsoUtil.logInfo(logger, "hash value is empty, going to splash page icn:" + 
				fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
			
			response.sendRedirect(fedCredSsoUtil.getSplashPageUrl());
			return false;
		}
		
		if(fedCredSsoUtil.isUserAccountDeactivated(username)) {
			fedCredSsoUtil.logInfo(logger, "user account is deactivated, going to error page icn:" + 
				fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM));
			
			fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.DEACTIVATED_ACCOUNT_MSG);
			response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			return false;
		}

		InPersonAuthenticationDTO ipa = fedCredSsoUtil.retrieveIpaByUserName(username);
		
		if(ipa == null) {
			fedCredSsoUtil.logInfo(logger, "IPA not found for username:" + username);
			response.sendRedirect(fedCredSsoUtil.getAnonymousUrl());
			return false;
		} else if(fedCredSsoUtil.isIpaAuthenticated(ipa)) {
			fedCredSsoUtil.logInfo(logger, "IPA is authenticated for username:" + username);
			fedCredSsoUtil.processFacilitiesUpdate(ipa.getPatient());
			fedCredSsoUtil.processLastLogin(ipa.getPatient().getUserProfile(), fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.CSID_PARAM));
			fedCredSsoUtil.populateEauthHash(ipa.getPatient().getUserProfile(), hash, fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.CSID_PARAM));
			fedCredSsoUtil.determineDeepLinkingPage(response);
			return false;
		} else {
			if(fedCredSsoUtil.goToOnlineAuthenticationPage(username, request)) {
				response.sendRedirect(fedCredSsoUtil.getOnlineAuthenticationUrl());
				return false;
			} 
			fedCredSsoUtil.logInfo(logger, "Going to MHV Logged In Page username:" + username);
			response.sendRedirect(fedCredSsoUtil.getMHVLoggedInUrl());
			return true;
		}
	}

	
	//After coming in from Splash page
//	public String processDsLogonSSoForNewUser(HttpServletRequest request) throws UnsupportedEncodingException {
//		boolean checkEdipi = false;
//		
//		//Jazz #110471 RemoteID Proofing - REQ#1 - For SSO user, MHV system shall extract ICN from the VAAFI header
//		String icn = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.ICN_PARAM);
//		
//		//Jazz #110471 RemoteID Proofing - REQ#1 - and send it to MVI with getCorrespondingID call after making following validation checks:
//		if(icn!=null){
//			if(!fedCredSsoUtil.isICNValid(icn)) {
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.INVALID_ICN_MSG);
//				return "ErrorPage";
//			}
//			
//			//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
//			String versionInfo = fedCredSsoUtil.VERSION_INFO_SEARCH_JOB; 
//			mviPatRes = 
//				gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
//					searchPersonInMVIByICNWithVersion(icn, versionInfo);
//
//			req.getSession().removeAttribute(MULTIPLE_ACCOUNT_ERROR_ATTRIB);
//			if(mviPatRes != null && mviPatRes.getValue() != null && mviPatRes.getValue().equals(MVI_COMM_ISSUE_VALUE)) {
//				return "MVIErrorPage";
//			} else if(mviPatRes != null && mviPatRes.getValue() != null && mviPatRes.getValue().equals(MviConstants.MULTIPLE_IDS_ERROR)) {
//				//JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see if the user has one active advanced account known to MVI,
//				//in the event multiple accounts are returned from MVI, the system shall display a user-friendly error message in a
//				//yellow box at the top of We Cannot Connect Your Account page.
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//				return "ErrorPage";
//			} else if(mviPatRes != null && mviPatRes.getValue() != null && mviPatRes.getValue().toString().startsWith(ERROR_VALUE)) {
//				//JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see if the user has one active advanced account known to MVI,
//				//in the event multiple accounts are returned from MVI, the system shall display a user-friendly error message in a
//				//yellow box at the top of We Cannot Connect Your Account page.
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, mviPatRes.getValue().toString());
//				return "ErrorPage";
//			}
//
//			if (mviPatRes != null && mviPatRes.getPatient() != null) {
//				patient = mviPatRes.getPatient();
//			}
//
//			//NOTE: After the final discussion with Carnetta, we are not checking the ICN in our database but checking with MVI.
//			//Jazz #110471 RemoteID Proofing - REQ#1 - If ICN is valid, then MHV should check in our DB and see if user exists with this ICN
////			PatientServiceResponse patRes =
////				gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createPatientServiceDelegate().getPatientByIcn(icn);
////			patient = patRes.getPatient();
//
//			//Jazz #110471 RemoteID Proofing - REQ#1 - i.	If ICN is not found in MHV DB then MHV to check for EDIPI
//			if(patient == null) {
//				checkEdipi = true;
//			} else if(patient.getUserProfile().getDeactivationReason()!=null) {
//				//Jazz #110471 RemoteID Proofing - REQ#1 - For inactive accounts, throw existing error message.
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.DEACTIVATED_ACCOUNT_MSG);
//				return "ErrorPage";
//			}
//
//		//JAZZ Story#39187 - US REQ#3.0 For the first time SSO user coming to MHV using any credential, MHV system shall use the EDIPI value if it exists or
//		//the user traits (firstName, middleName, lastName, birthdate, gender, ssn) to search in MVI.
//		//Check if EDIPI is 10 numeric characters, if not then dont use the EDIPI and check user traits in VAAFI header.
//	    } else {
//	    	//Jazz #110471 RemoteID Proofing - REQ#1 - If ICN does not exists then check for EDIPI
//	    	checkEdipi = true;
//	    }
//
//		String edipiValue = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.EDIPI_PARAM);
//		String firstName = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.FIRST_NAME);
//		String middleName = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.MIDDLE_NAME);
//		String lastName = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.LAST_NAME);
//		String birthDate = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.BIRTH_DATE);
//		String ssn = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.ID);
//		String gender = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.GENDER);
//		String idType = fedCredSsoUtil.retrieveVAFFIProperty(request, fedCredSsoUtil.ID_TYPE);
//		
//		if(checkEdipi) {
//					
//			if(fedCredSsoUtil.isEdipiValid(edipiValue)) {
//				//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
//				String versionInfo = fedCredSsoUtil.VERSION_INFO_SEARCH_JOB; 
//				mviPatRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
//					searchPersonInMVIForDSLogonWithVersion(edipiValue, versionInfo);
//			} else {
//				//If  "NOT_FOUND" is sent in "first name", "last name" , "birth date", "ssn" and "gender" , MHV will show error msg
//				if(fedCredSsoUtil.isNotFound(firstName) || fedCredSsoUtil.isNotFound(lastName) || fedCredSsoUtil.isNotFound(birthDate) || 
//				   fedCredSsoUtil.isNotFound(ssn)) {
//					request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.NOT_FOUND_ERROR_MSG);
//					return "ErrorPage";
//				}
//
//				middleName = fedCredSsoUtil.processMiddleName(middleName);
//				gender = fedCredSsoUtil.processGender(gender);
//				ssn = fedCredSsoUtil.processSsn(ssn);
//
//				//If SSN is not 9 digit, MHV will show error msg
//				if(!isSsnValid(ssn, idType)) {
//					request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.INVALID_SSN_MSG);
//					return "ErrorPage";
//				}
//
//				//birth date is not in Date format, MHV will show error msg
//				if(!fedCredSsoUtil.isDate(birthDate)) {
//					request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.INVALID_DOB_MSG);
//					return "ErrorPage";
//				}
//
//				//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
//				String versionInfo = fedCredSsoUtil.VERSION_INFO_SEARCH_JOB; 
//				mviPatRes = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
//					searchPersonInMVIForUSAAWithVersion(firstName, middleName, lastName, birthDate, gender, ssn, versionInfo);
//			}
//
//			if(mviPatRes != null && mviPatRes.getValue() != null && mviPatRes.getValue().equals(fedCredSsoUtil.MVI_COMM_ISSUE_VALUE)) {
//				return "MVIErrorPage";
//			} else if(mviPatRes != null && mviPatRes.getValue() != null && mviPatRes.getValue().equals(MviConstants.MULTIPLE_IDS_ERROR)) {
//				//JAZZ Story#39187 - US REQ#2.0 When MHV system checks to see if the user has one active advanced account known to MVI,
//				//in the event multiple accounts are returned from MVI, the system shall display a user-friendly error message in a
//				//yellow box at the top of We Cannot Connect Your Account page.
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.MULTIPLE_ACCOUNT_ERROR_MSG);
//				return "ErrorPage";
//			}
//
//			if (mviPatRes != null && mviPatRes.getPatient() != null) {
//				patient = mviPatRes.getPatient();
//			}
//		}
//
//		if(patient != null) {
//			uProfile = patient.getUserProfile();
//
//			if(isDeactivated(uProfile.getUserName())) {
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.DEACTIVATED_ACCOUNT_MSG);
//				return "ErrorPage";
//			}
//
//			//In the event MVI returns a different SSN value, MHV will show error msg.
//			if(!ssn.equals(uProfile.getSsn().replaceAll("[\\s\\-()]", ""))) {
//				request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.INVALID_SSN_MSG);
//				return "ErrorPage";
//			}
//
//				//Jazz #110471 US REQ#3 RemoteID Proofing - For the users who want to map their account, MHV system shall display
//			//updated content for the MHV Connect Page where user can select to go to MHV
//				//Jazz #110471 US REQ#3 RemoteID Proofing - If the Correlation status = Pending Uncorrelation/Correlation Failed
//				//then throw existing 12.9 error message.
//				enterInfoLog("Correlation Status:" + patient.getCorrelationStatus().getName(), icn);
//		    	if(patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.PENDING_UNCORRELATION)||
//		    	   patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.FAILED_CORRELATION)) {
//					request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, fedCredSsoUtil.PENDING_UNCORRELATION_MSG);
//					return "ErrorPage";
//		    	}
//
//		    	//Jazz #110471 US REQ#3 RemoteID Proofing - b.	Then check for Matched Date:
//		    	//i.	If there is no Match Date, MHV will match the record and set the match date to todays date (Note for Dev: use the code in admin portal for match button)
//		    	//ii.	If matching fails MHV will display the 12.9 error message to the user.
//		    	if(patient.getMatchedDateTime() == null) {
//					enterInfoLog("Processed MVI Match for ICN:", icn);
//		    		MviIntegrationServiceDelegate mviSyncServiceDelegate = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate();
//
//		    		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
//		    		PatientServiceResponse response = mviSyncServiceDelegate.matchPersonInIPAWithVersion(uProfile, getVersionInfo(patient.getUserProfile()));
//		    		
//		    		patient = response.getPatient();
//		    		if(response.getMessages().hasErrorMessages()) {
//						request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, retrieveErrorMessages(response.getMessages()));
//						return "ErrorPage";
//		    		}
//					enterInfoLog("MVI Match successful for ICN:", icn);
//		    	}
//
//		    	//Jazz #110471 US REQ#3 RemoteID Proofing - c.	Then check  for Correlated Status
//		    	//i.	If there is no Correlation (Correlation status = UnCorrelated), MHV will correlate the user (Note for Dev: use the code in admin portal for Correlate button)
//		    	//ii.	If correlation fails, MHV shall put the record in failed correlation state and user will see the existing 12.9 error message.
//		    	if(patient.getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.UNCORRELATED) ||
//		    	   patient.getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.MVIDATAMATCH)) {
//					enterInfoLog("Processed MVI Correlation for ICN:", icn);
//		    		MviIntegrationServiceDelegate mviSyncServiceDelegate = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate();
//		    		PatientServiceResponse mviSyncServiceResponse =
//		    			mviSyncServiceDelegate.addPersonForCorrelationForIPAWithVersion(
//		    					patient, patient.getUserProfile(), "", getVersionInfo(patient.getUserProfile()));
//
//		    		patient = mviSyncServiceResponse.getPatient();
//		    		uProfile = patient.getUserProfile();
//
//		    		if(mviSyncServiceResponse.getMessages().hasErrorMessages()) {
//						request.getSession().setAttribute(fedCredSsoUtil.ERROR_DETAIL, retrieveErrorMessages(mviSyncServiceResponse.getMessages()));
//						return "MVIErrorPage";
//		    		}
//					enterInfoLog("MVI Correlation successful", icn);
//		    	}
//
////				req.getSession().removeAttribute(DISPLAY_ERROR);
////				goToReauthPage(req, res, uProfile.getUserName());
//				return "ReauthPage";
//		}
//			
//	}

	private String determineDeepLinkingPage() {
//TODO - Uncomment
//		if(null != deepLink){
//		if(deepLink.equalsIgnoreCase("download_my_data"))
//			portal_url = mhv_portal_custom + "?_nfpb=true&_nfls=false&_pageLabel=downloadData";
//		else if(deepLink.equalsIgnoreCase("prescription_refill"))
//			portal_url = mhv_portal_custom + "?_nfpb=true&_pageLabel=rxRefill&_nfls=false";
//		else if(deepLink.equalsIgnoreCase("appointments"))
//			portal_url = mhv_portal_custom + "?_nfpb=true&_pageLabel=appointments&_nfls=false";
//		else if(deepLink.equalsIgnoreCase("secure_messaging"))
//			portal_url = mhv_portal_custom + "?_nfpb=true&_nfto=false&_pageLabel=secureMessagingPage";
//	}
		return "loggedInPage";
	}
	
	private String findUserNameByHash(String hash) {
		if(hash.length()>28) {
			//TODO - Uncomment
			//hash = EncodingUtil.decodeXSS(ahash);
		}

		//EAuthHashServiceDelegate esd = ServiceDelegateFactory.createEAuthHashServiceDelegate();x
		//StringServiceResponse ssr = esd.findUserNameByHash(ahash);
		//return ssr.getString();
		return null;
	}
	
	private boolean isDigit(String number) {
		char[] numberArray = number.toCharArray();
		for (int i = 0; i < numberArray.length; i++) {
			if(!Character.isDigit(numberArray[i])) {
				return false;
			}
		}
		return true;
	}
	
	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		try {
			processDsLogonSSoForExistingUser(request, response);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ActionException(e);
		}		
	}
	
	public boolean process(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		boolean sso = false;
		try {
			sso = processDsLogonSSoForExistingUser(request, response);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ActionException(e);
		}		
		return sso;
	}
}